/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.game.AutoPlayer;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.network.CardPlayPayload;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CardGame<G extends CardGame<G>> {
    public static CardPlayer TABLE = new AutoPlayer(0.0f){

        @Override
        public class_2561 getName() {
            return class_2561.method_43473();
        }
    };
    protected final Map<CardPlayer, GameSlot> hands = new HashMap<CardPlayer, GameSlot>();
    protected final Map<CardPlayer, GameSlot> censoredHands = new HashMap<CardPlayer, GameSlot>();
    protected final List<Runnable> scheduledActions = new ArrayList<Runnable>();
    private final List<GameSlot> gameSlots = new ArrayList<GameSlot>();
    protected final List<CardPlayer> players;
    protected final CardDeck deck;
    protected final List<Card> gameDeck;
    protected final Set<Suit> gameSuits;
    protected CardPlayer currentPlayer;
    protected boolean isGameReady;
    protected boolean isGameOver;

    public CardGame(List<CardPlayer> players, CardDeck deck) {
        this.players = players;
        this.deck = deck;
        this.gameDeck = deck.getCards().stream().filter(c -> this.getCardPredicate().test((Card)c)).map(Card::copy).collect(Collectors.toList());
        this.gameDeck.forEach(Card::flip);
        this.gameSuits = this.gameDeck.stream().map(Card::getSuit).collect(Collectors.toSet());
    }

    public abstract AbstractCardMenu<G> createMenu(int var1, class_1661 var2, class_3218 var3, class_2338 var4, CardDeck var5);

    public abstract Predicate<CardDeck> getDeckPredicate();

    public abstract Predicate<Card> getCardPredicate();

    public abstract boolean canPlay(CardPlayer var1, CardPlay var2);

    public abstract void startGame();

    public abstract void runGame();

    public abstract void endGame();

    public abstract List<GameOption<?>> getOptions();

    public final byte[] getRawOptions() {
        List<GameOption<?>> options = this.getOptions();
        byte[] byteArray = new byte[options.size()];
        for (int i = 0; i < options.size(); ++i) {
            byteArray[i] = options.get(i).getValue();
        }
        return byteArray;
    }

    public void setRawOptions(byte[] options) {
        List<GameOption<?>> o = this.getOptions();
        for (int i = 0; i < o.size(); ++i) {
            if (i >= options.length) continue;
            o.get(i).setValue(options[i]);
        }
    }

    public List<CardPlayer> getPlayers() {
        return this.players;
    }

    public List<GameSlot> getSlots() {
        return this.gameSlots;
    }

    public GameSlot getSlot(int index) {
        return this.gameSlots.get(index);
    }

    protected <S extends GameSlot> S addSlot(S slot) {
        slot.setIndex(this.gameSlots.size());
        this.gameSlots.add(slot);
        return slot;
    }

    public boolean isGameReady() {
        return this.isGameReady;
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    protected GameSlot createPlayerHand(CardPlayer player) {
        return new GameSlot(player.hand());
    }

    public GameSlot getPlayerHand(CardPlayer player) {
        return this.hands.computeIfAbsent(player, this::createPlayerHand);
    }

    protected GameSlot createCensoredHand(CardPlayer player) {
        LinkedList list = new LinkedList();
        this.getPlayerHand(player).stream().map(c -> Card.BLANK).forEach(list::add);
        return new GameSlot(this, list){

            @Override
            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            @Override
            public boolean canRemoveCard(CardPlayer player, int index) {
                return false;
            }
        };
    }

    public GameSlot getCensoredHand(@Nullable CardPlayer viewer, CardPlayer player) {
        if (viewer == player && player.getEntity() instanceof class_3222) {
            return this.hands.getOrDefault(player, new GameSlot());
        }
        return this.censoredHands.computeIfAbsent(player, this::createCensoredHand);
    }

    public GameSlot getCensoredHand(CardPlayer player) {
        return this.getCensoredHand(null, player);
    }

    public CardPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(int index) {
        this.currentPlayer = this.getPlayers().get(index);
    }

    protected Stream<Card> getFullHand(CardPlayer player) {
        class_1309 entity = player.getEntity();
        if (entity instanceof class_3222) {
            AbstractCardMenu menu;
            class_3222 serverPlayer = (class_3222)entity;
            class_1703 class_17032 = serverPlayer.field_7512;
            if (class_17032 instanceof AbstractCardMenu && !(menu = (AbstractCardMenu)class_17032).getCarriedCards().isEmpty()) {
                return Stream.concat(this.getPlayerHand(player).stream(), menu.getCarriedCards().stream());
            }
        }
        return this.getPlayerHand(player).stream();
    }

    protected Suit getMostFrequentSuit(CardPlayer player) {
        HashMap<Suit, Integer> suitCountMap = new HashMap<Suit, Integer>();
        for (Card c : this.getPlayerHand(player).getCards()) {
            Suit suit = c.getSuit();
            suitCountMap.put(suit, suitCountMap.getOrDefault((Object)suit, 0) + 1);
        }
        Suit mostFrequentSuit = null;
        int maxCount = 0;
        for (Map.Entry entry : suitCountMap.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            mostFrequentSuit = (Suit)((Object)entry.getKey());
            maxCount = (Integer)entry.getValue();
        }
        return mostFrequentSuit;
    }

    @Nullable
    public CardPlay getBestPlay(CardPlayer player) {
        int i = 0;
        while (i < this.gameSlots.size()) {
            int slot = i++;
            Optional<Card> card = this.getFullHand(player).filter(c -> this.canPlay(player, new CardPlay(List.of(c), slot))).findFirst();
            if (!card.isPresent()) continue;
            return new CardPlay(List.of(card.get()), slot);
        }
        return null;
    }

    public void openScreen(class_3222 serverPlayer, final class_3218 level, final class_2338 pos, final CardDeck deck) {
        serverPlayer.method_17355((class_3908)new ExtendedScreenHandlerFactory<class_9129>(){

            public class_9129 getScreenOpeningData(class_3222 serverPlayer) {
                class_9129 buf = new class_9129(Unpooled.buffer(), serverPlayer.method_56673());
                buf.method_10807(pos);
                CardDeck.STREAM_CODEC.encode((Object)buf, (Object)deck);
                buf.method_10806(CardGame.this.getPlayers().stream().mapToInt(CardPlayer::getId).toArray());
                buf.method_10813(CardGame.this.getRawOptions());
                return buf;
            }

            @NotNull
            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @NotNull
            public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                return CardGame.this.createMenu(containerId, playerInventory, level, pos, deck);
            }
        });
    }

    public void tick() {
        if (!this.isGameReady) {
            if (!this.scheduledActions.isEmpty()) {
                this.scheduledActions.removeFirst().run();
            } else {
                this.isGameReady = true;
                this.runGame();
            }
        } else {
            this.getPlayers().forEach(p -> p.tick(this));
        }
    }

    public int getMinPlayers() {
        return 2;
    }

    public int getMaxPlayers() {
        return 8;
    }

    protected void dealCards(GameSlot drawSlot, CardPlayer player, int count) {
        for (int i = 0; i < count; ++i) {
            Card card = drawSlot.removeLast();
            card.flip();
            this.getPlayerHand(player).add(card);
            this.getCensoredHand(player).add(Card.BLANK);
        }
    }

    protected void table(class_2561 play) {
        this.play(TABLE, (class_2561)play.method_27661().method_27692(class_124.field_1080));
    }

    protected void play(CardPlayer player, class_2561 play) {
        for (CardPlayer p : this.getPlayers()) {
            class_1309 entity = p.getEntity();
            if (!(entity instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)entity;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new CardPlayPayload((class_2561)(player.getName().equals((Object)class_2561.method_43473()) ? class_2561.method_43473() : player.getColoredName()), this.getPlayerHand(player).size(), play));
        }
    }

    public static boolean canPlayGame(CardGame<?> cardGame, CardDeck cardDeck) {
        return cardGame.getDeckPredicate().test(cardDeck);
    }
}

